package cn.boboweike.carrot;

import cn.boboweike.carrot.server.dashboard.DashboardNotification;
import cn.boboweike.carrot.utils.diagnostics.DiagnosticsBuilder;

import java.io.Serializable;

public class SevereCarrotException extends CarrotException implements DashboardNotification  {
    private final DiagnosticsAware diagnosticsAware;

    public SevereCarrotException(String message, DiagnosticsAware diagnosticsAware) {
        super(message);
        this.diagnosticsAware = diagnosticsAware;
    }

    public DiagnosticsBuilder getDiagnostics() {
        return diagnosticsAware.getDiagnosticsInfo();
    }

    public interface DiagnosticsAware extends Serializable {
        DiagnosticsBuilder getDiagnosticsInfo();
    }
}
