package cn.boboweike.carrot.configuration;

import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.server.metrics.BackgroundTaskServerMetricsBinder;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.metrics.StorageProviderMetricsBinder;
import io.micrometer.core.instrument.MeterRegistry;

/**
 * A wrapper around a Micrometer {@link MeterRegistry} that allows to integrate Micrometer with Carrot.
 *
 * This wrapper is needed as otherwise the CarrotConfiguration class would have a dependency on Micrometer which is optional.
 */
public class CarrotMicroMeterIntegration implements AutoCloseable {
    private final MeterRegistry meterRegistry;
    private StorageProviderMetricsBinder storageProviderMetricsBinder;
    private BackgroundTaskServerMetricsBinder backgroundTaskServerMetricsBinder;

    public CarrotMicroMeterIntegration(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public void initialize(PartitionedStorageProvider storageProvider, BackgroundTaskServer backgroundTaskServer) {
        storageProviderMetricsBinder =
                new StorageProviderMetricsBinder(storageProvider, meterRegistry);
        if(backgroundTaskServer != null) {
            backgroundTaskServerMetricsBinder = new BackgroundTaskServerMetricsBinder(backgroundTaskServer, meterRegistry);
        }
    }

    public void close() {
        storageProviderMetricsBinder.close();
        if(backgroundTaskServerMetricsBinder != null) {
            backgroundTaskServerMetricsBinder.close();
        }
    }
}
