package cn.boboweike.carrot.dashboard;

/**
 * This class allows to configure the CarrotDashboard
 */
public class CarrotDashboardWebServerConfiguration {
    int port = 8000;
    String username = null;
    String password = null;

    private CarrotDashboardWebServerConfiguration() {

    }

    /**
     * This returns the default configuration with the CarrotDashboard running on port 8000
     *
     * @return the default CarrotDashboard configuration
     */
    public static CarrotDashboardWebServerConfiguration usingStandardDashboardConfiguration() {
        return new CarrotDashboardWebServerConfiguration();
    }

    /**
     * Specifies the port on which the CarrotDashboard will run
     *
     * @param port the port on which the CarrotDashboard will run
     * @return the same configuration instance which provides a fluent api
     */
    public CarrotDashboardWebServerConfiguration andPort(int port) {
        this.port = port;
        return this;
    }

    /**
     * Adds basic authentication to the dashboard using the provided username and password.
     * <span class="strong">WARNING</span> the password will be stored in clear text and if you are using http, it can be easily intercepted.
     *
     * @param username the login which the CarrotDashboard will ask
     * @param password the password which the CarrotDashboard will ask
     * @return the same configuration instance which provides a fluent api
     */
    public CarrotDashboardWebServerConfiguration andBasicAuthentication(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }
}
