package cn.boboweike.carrot.dashboard;

import cn.boboweike.carrot.dashboard.server.sse.ServerSentEventHandler;
import cn.boboweike.carrot.dashboard.server.sse.SseExchange;
import cn.boboweike.carrot.dashboard.sse.BackgroundTaskServerStatusSseExchange;
import cn.boboweike.carrot.dashboard.sse.TaskSseExchange;
import cn.boboweike.carrot.dashboard.sse.TaskStatsListSseExchange;
import cn.boboweike.carrot.dashboard.sse.TaskStatsSseExchange;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import com.sun.net.httpserver.HttpExchange;

import java.io.IOException;

public class CarrotSseHandler extends ServerSentEventHandler {

    private final PartitionedStorageProvider storageProvider;
    private final JsonMapper jsonMapper;

    public CarrotSseHandler(PartitionedStorageProvider storageProvider, JsonMapper jsonMapper) {
        this("/sse", storageProvider, jsonMapper);
    }

    public CarrotSseHandler(String contextPath, PartitionedStorageProvider storageProvider, JsonMapper jsonMapper) {
        super(contextPath);
        this.storageProvider = storageProvider;
        this.jsonMapper = jsonMapper;
    }

    @Override
    protected SseExchange createSseExchange(HttpExchange httpExchange) throws IOException {
        final String requestUri = httpExchange.getRequestURI().toString();
        if (requestUri.startsWith("/sse/taskstats")) {
            return new TaskStatsSseExchange(httpExchange, storageProvider, jsonMapper);
        } else if (requestUri.startsWith("/sse/listtaskstats")) {
            return new TaskStatsListSseExchange(httpExchange, storageProvider, jsonMapper);
        } else if (requestUri.startsWith("/sse/servers")) {
            return new BackgroundTaskServerStatusSseExchange(httpExchange, storageProvider, jsonMapper);
        } else if (requestUri.startsWith("/sse/tasks")) {
            return new TaskSseExchange(httpExchange, storageProvider, jsonMapper);
        }
        throw  new IllegalStateException("Unsupported httpExchange");
    }
}
