package cn.boboweike.carrot.dashboard.sse;

import cn.boboweike.carrot.storage.BackgroundTaskServerStatus;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.listeners.BackgroundTaskServerStatusChangeListener;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import com.sun.net.httpserver.HttpExchange;

import java.io.IOException;
import java.util.List;

public class BackgroundTaskServerStatusSseExchange extends AbstractObjectSseExchange implements BackgroundTaskServerStatusChangeListener {
    private static String lastMessage;

    private final PartitionedStorageProvider storageProvider;

    public BackgroundTaskServerStatusSseExchange(HttpExchange httpExchange, PartitionedStorageProvider storageProvider, JsonMapper jsonMapper) throws IOException {
        super(httpExchange, jsonMapper);
        this.storageProvider = storageProvider;
        storageProvider.addTaskStorageOnChangeListener(this);
        sendMessage(lastMessage);
    }

    @Override
    public void onChange(List<BackgroundTaskServerStatus> changedServerStates) {
        lastMessage = sendObject(changedServerStates);
    }

    @Override
    public void close() {
        storageProvider.removeTaskStorageOnChangeListener(this);
        super.close();
    }
}
