package cn.boboweike.carrot.dashboard.sse;

import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.listeners.TaskChangeListener;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskId;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import com.sun.net.httpserver.HttpExchange;

import java.io.IOException;

import static cn.boboweike.carrot.tasks.states.StateName.*;

public class TaskSseExchange extends AbstractObjectSseExchange implements TaskChangeListener {
    private final PartitionedStorageProvider storageProvider;
    private final TaskId taskId;

    public TaskSseExchange(HttpExchange httpExchange, PartitionedStorageProvider storageProvider, JsonMapper jsonMapper) throws IOException {
        super(httpExchange, jsonMapper);
        this.storageProvider = storageProvider;
        this.taskId = getTaskId(httpExchange);
        storageProvider.addTaskStorageOnChangeListener(this);
    }

    @Override
    public TaskId getTaskId() {
        return taskId;
    }

    @Override
    public void onChange(Task task) {
        sendObject(task);
        if (task.hasState(SUCCEEDED) || task.hasState(FAILED) || task.hasState(DELETED)) {
            close();
        }
    }

    @Override
    public void close() {
        storageProvider.removeTaskStorageOnChangeListener(this);
        super.close();
    }

    private static TaskId getTaskId(HttpExchange httpExchange) {
        final String url = httpExchange.getRequestURI().toString();
        return TaskId.parse(url.substring("/sse/tasks/".length()));
    }
}
