package cn.boboweike.carrot.dashboard.ui.model;

import cn.boboweike.carrot.tasks.RecurringTask;

import java.time.Instant;

public class RecurringTaskUIModel extends RecurringTask {
    private final Instant nextRun;

    public RecurringTaskUIModel(RecurringTask recurringTask) {
        super(recurringTask.getId(), recurringTask.getTaskDetails(), recurringTask.getScheduleExpression(), recurringTask.getZoneId(), recurringTask.getCreatedAt().toString());
        setTaskName(recurringTask.getTaskName());
        nextRun = super.getNextRun();
    }

    @Override
    public Instant getNextRun() {
        return nextRun;
    }
}
