package cn.boboweike.carrot.dashboard.ui.model;

import cn.boboweike.carrot.configuration.Carrot;
import cn.boboweike.carrot.utils.metadata.VersionRetriever;

public class VersionUIModel {
    private String version;
    private boolean allowAnonymousDataUsage;
    private String clusterId;
    private String storageProviderType;

    private VersionUIModel() {
        this.version = VersionRetriever.getVersion(Carrot.class);
        this.allowAnonymousDataUsage = false;
    }

    private VersionUIModel(String clusterId, String storageProviderType) {
        this.storageProviderType = storageProviderType;
        this.version = VersionRetriever.getVersion(Carrot.class);
        this.allowAnonymousDataUsage = true;
        this.clusterId = clusterId;
    }

    public String getVersion() {
        return version;
    }

    public boolean isAllowAnonymousDataUsage() {
        return allowAnonymousDataUsage;
    }

    public String getClusterId() {
        return clusterId;
    }

    public static VersionUIModel withAnonymousDataUsage(String clusterId, String storageProviderType) {
        return new VersionUIModel(clusterId, storageProviderType);
    }

    public static VersionUIModel withoutAnonymousDataUsage() {
        return new VersionUIModel();
    }
}
