package cn.boboweike.carrot.dashboard.ui.model.problems;

import cn.boboweike.carrot.server.dashboard.CpuAllocationIrregularityNotification;
import cn.boboweike.carrot.storage.CarrotMetadata;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.listeners.MetadataChangeListener;

import java.util.List;

public class CpuAllocationIrregularityProblemHandler implements MetadataChangeListener, ProblemHandler {
    private final Problems problems;
    private final PartitionedStorageProvider storageProvider;
    private List<CarrotMetadata> serversWithLongGCCyclesMetadataList;

    public CpuAllocationIrregularityProblemHandler(Problems problems, PartitionedStorageProvider storageProvider) {
        this.problems = problems;
        this.storageProvider = storageProvider;
        this.storageProvider.addTaskStorageOnChangeListener(this);
        this.onChange(storageProvider.getMetadata(CpuAllocationIrregularityNotification.class.getSimpleName()));
    }

    @Override
    public void dismiss() {
        problems.removeProblemsOfType(CpuAllocationIrregularityProblem.PROBLEM_TYPE);
        storageProvider.deleteMetadata(CpuAllocationIrregularityNotification.class.getSimpleName());
    }

    @Override
    public String listenForChangesOfMetadataName() {
        return CpuAllocationIrregularityNotification.class.getSimpleName();
    }

    @Override
    public void onChange(List<CarrotMetadata> metadataList) {
        if (this.serversWithLongGCCyclesMetadataList == null || this.serversWithLongGCCyclesMetadataList.size() != metadataList.size()) {
            problems.removeProblemsOfType(CpuAllocationIrregularityProblem.PROBLEM_TYPE);
            if (!metadataList.isEmpty()) {
                problems.addProblem(new CpuAllocationIrregularityProblem(metadataList));
            }
            this.serversWithLongGCCyclesMetadataList = metadataList;
        }
    }
}
