package cn.boboweike.carrot.dashboard.ui.model.problems;

import cn.boboweike.carrot.storage.PartitionedStorageProvider;

import java.util.HashMap;
import java.util.Map;

public class ProblemsManager {
    private final PartitionedStorageProvider storageProvider;
    private final Problems problems;
    private final Map<String, ProblemHandler> problemHandlers;

    public ProblemsManager(PartitionedStorageProvider storageProvider) {
        this.storageProvider = storageProvider;
        this.problems = new Problems();
        this.problemHandlers = initProblemHandlers();
    }

    private Map<String, ProblemHandler>  initProblemHandlers() {
        Map<String, ProblemHandler> result = new HashMap<>();
        result.put(ScheduledTasksNotFoundProblem.PROBLEM_TYPE, new ScheduledTasksNotFoundProblemHandler(problems, storageProvider));
        result.put(SevereCarrotExceptionProblem.PROBLEM_TYPE, new SevereCarrotExceptionProblemHandler(problems, storageProvider));
        result.put(CpuAllocationIrregularityProblem.PROBLEM_TYPE, new CpuAllocationIrregularityProblemHandler(problems, storageProvider));
        return result;
    }

    public Problems getProblems() {
        return problems;
    }

    public void dismissProblemOfType(String param) {
        if (problemHandlers.containsKey(param)) {
            problemHandlers.get(param).dismiss();
        } else {
            throw new IllegalArgumentException("Unknown problem of type '" + param + "'");
        }
    }
}
