package cn.boboweike.carrot.dashboard.ui.model.problems;

import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.TaskStats;
import cn.boboweike.carrot.storage.TaskStatsData;
import cn.boboweike.carrot.storage.listeners.TaskStatsChangeListener;
import cn.boboweike.carrot.tasks.states.StateName;

import java.util.Set;

import static cn.boboweike.carrot.utils.TaskUtils.taskExists;
import static java.util.stream.Collectors.toSet;

public class ScheduledTasksNotFoundProblemHandler implements TaskStatsChangeListener, ProblemHandler {

    private final Problems problems;
    private final PartitionedStorageProvider storageProvider;
    private TaskStats taskStats;

    public ScheduledTasksNotFoundProblemHandler(Problems problems, PartitionedStorageProvider storageProvider) {
        this.problems = problems;
        this.storageProvider = storageProvider;
        this.storageProvider.addTaskStorageOnChangeListener(this);
    }

    @Override
    public void dismiss() {
        throw new IllegalStateException("Problem of type '" + ScheduledTasksNotFoundProblem.PROBLEM_TYPE + "' cannot be dismissed.");
    }

    @Override
    public void onChange(TaskStatsData taskStatsData) {
        if (this.taskStats == null || taskStatsData.getOverallTaskStats().getScheduled() < this.taskStats.getScheduled()) {
            initScheduledTaskNotFoundProblems();
            this.taskStats = taskStatsData.getOverallTaskStats();
        }
    }

    private void initScheduledTaskNotFoundProblems() {
        problems.removeProblemsOfType(ScheduledTasksNotFoundProblem.PROBLEM_TYPE);
        Set<String> tasksThatCannotBeFoundAnymore =
                storageProvider.getDistinctTaskSignatures(StateName.SCHEDULED)
                .stream().filter(taskSignature -> !taskExists(taskSignature)).collect(toSet());
        if (!tasksThatCannotBeFoundAnymore.isEmpty()) {
            storageProvider.addTaskStorageOnChangeListener(this);
            taskStats = storageProvider.getTaskStatsData().getOverallTaskStats();
            problems.addProblem(new ScheduledTasksNotFoundProblem(tasksThatCannotBeFoundAnymore));
        } else {
            storageProvider.removeTaskStorageOnChangeListener(this);
        }
    }

}
