package cn.boboweike.carrot.dashboard.ui.model.problems;

import cn.boboweike.carrot.storage.CarrotMetadata;

import java.util.List;

import static java.util.stream.Collectors.joining;

public class SevereCarrotExceptionProblem extends Problem {
    public static final String PROBLEM_TYPE = "severe-carrot-exception";

    private final String githubIssueTitle;
    private final String githubIssueBody;
    private final int githubIssueBodyLength;

    public SevereCarrotExceptionProblem(List<CarrotMetadata> carrotMetadataSetWithSevereCarrotExceptions) {
        super(PROBLEM_TYPE);
        this.githubIssueTitle = "Severe Carrot Exception";
        this.githubIssueBody = carrotMetadataSetWithSevereCarrotExceptions.stream().map(CarrotMetadata::getValue).collect(joining("\n\n\n"));
        this.githubIssueBodyLength = githubIssueBody.length();
    }

    public String getGithubIssueTitle() {
        return githubIssueTitle;
    }

    public String getGithubIssueBody() {
        return githubIssueBody;
    }

    public int getGithubIssueBodyLength() {
        return githubIssueBodyLength;
    }
}
