package cn.boboweike.carrot.dashboard.ui.model.problems;

import cn.boboweike.carrot.SevereCarrotException;
import cn.boboweike.carrot.storage.CarrotMetadata;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.listeners.MetadataChangeListener;

import java.util.List;

public class SevereCarrotExceptionProblemHandler implements MetadataChangeListener, ProblemHandler {
    private final Problems problems;
    private final PartitionedStorageProvider storageProvider;
    private List<CarrotMetadata> severeCarrotExceptionAsMetadataList;

    public SevereCarrotExceptionProblemHandler(Problems problems, PartitionedStorageProvider storageProvider) {
        this.problems = problems;
        this.storageProvider = storageProvider;
        this.storageProvider.addTaskStorageOnChangeListener(this);
        this.onChange(storageProvider.getMetadata(SevereCarrotException.class.getSimpleName()));
    }

    @Override
    public void dismiss() {
        problems.removeProblemsOfType(SevereCarrotExceptionProblem.PROBLEM_TYPE);
        storageProvider.deleteMetadata(SevereCarrotException.class.getSimpleName());
    }

    @Override
    public String listenForChangesOfMetadataName() {
        return SevereCarrotException.class.getSimpleName();
    }

    @Override
    public void onChange(List<CarrotMetadata> metadataList) {
        if (this.severeCarrotExceptionAsMetadataList == null || this.severeCarrotExceptionAsMetadataList.size() != metadataList.size()) {
            problems.removeProblemsOfType(SevereCarrotExceptionProblem.PROBLEM_TYPE);
            if (!metadataList.isEmpty()) {
                problems.addProblem(new SevereCarrotExceptionProblem(metadataList));
            }
            this.severeCarrotExceptionAsMetadataList = metadataList;
        }
    }
}
