package cn.boboweike.carrot.server.concurrent;

import cn.boboweike.carrot.storage.ConcurrentTaskModificationException;


/**
 * Class responsible for resolving ConcurrentTaskModificationExceptions.
 * <p>
 * Concurrent Task Modifications can occur if:
 * - you are updating tasks (e.g. deleting or scheduling) that are already being processed by Carrot
 * - there is a bug in the StorageProvider
 * <p>
 * See {@link DefaultConcurrentTaskModificationResolver} and {@link UseStorageProviderTaskConcurrentTaskModificationResolver} for implementations.
 */
public interface ConcurrentTaskModificationResolver {
    void resolve(ConcurrentTaskModificationException e);
}
