package cn.boboweike.carrot.server.concurrent.statechanges;

import cn.boboweike.carrot.server.concurrent.ConcurrentTaskModificationResolveResult;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.states.StateName;

public interface AllowedConcurrentStateChange {
    default boolean matches(Task localTask, Task storageProviderTask) {
        return matches(localTask.getState(), storageProviderTask.getState());
    }

    boolean matches(StateName localState, StateName storageProviderState);

    ConcurrentTaskModificationResolveResult resolve(Task localTask, Task storageProviderTask);
}
