package cn.boboweike.carrot.server.concurrent.statechanges;

import static cn.boboweike.carrot.tasks.states.StateName.DELETED;
import static cn.boboweike.carrot.tasks.states.StateName.ENQUEUED;

/**
 * Needed for tasks that go from scheduled state to enqueued state while the task was already deleted.
 */
public class DeletedWhileEnqueuedConcurrentStateChange extends AbstractAllowedConcurrentStateChange {
    public DeletedWhileEnqueuedConcurrentStateChange() {
        super(ENQUEUED, DELETED);
    }
}
