package cn.boboweike.carrot.server.concurrent.statechanges;

import cn.boboweike.carrot.server.TaskZooKeeper;
import cn.boboweike.carrot.server.concurrent.ConcurrentTaskModificationResolveResult;
import cn.boboweike.carrot.tasks.Task;

import static cn.boboweike.carrot.tasks.states.StateName.DELETED;
import static cn.boboweike.carrot.tasks.states.StateName.PROCESSING;

public class DeletedWhileProcessingConcurrentStateChange extends AbstractAllowedConcurrentStateChange {
    private final TaskZooKeeper taskZooKeeper;

    public DeletedWhileProcessingConcurrentStateChange(TaskZooKeeper taskZooKeeper) {
        super(PROCESSING, DELETED);
        this.taskZooKeeper = taskZooKeeper;
    }

    @Override
    public ConcurrentTaskModificationResolveResult resolve(Task localTask, Task storageProviderTask) {
        localTask.delete("Task is already deleted in StorageProvider");
        final Thread threadProcessingTask = taskZooKeeper.getThreadProcessingTask(localTask);
        if (threadProcessingTask != null) {
            threadProcessingTask.interrupt();
        }
        return ConcurrentTaskModificationResolveResult.succeeded(localTask);
    }
}
