package cn.boboweike.carrot.server.configuration;

import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.server.strategy.BasicWorkDistributionStrategy;
import cn.boboweike.carrot.server.strategy.WorkDistributionStrategy;

public class DefaultBackgroundTaskServerWorkerPolicy implements BackgroundTaskServerWorkerPolicy {
    private final int workerCount;

    public DefaultBackgroundTaskServerWorkerPolicy() {
        // see https://tasks.zalando.com/en/tech/blog/how-to-set-an-ideal-thread-pool-size
        workerCount = (Runtime.getRuntime().availableProcessors() * 8);
    }

    @Override
    public WorkDistributionStrategy toWorkDistributionStrategy(BackgroundTaskServer backgroundTaskServer) {
        return new BasicWorkDistributionStrategy(backgroundTaskServer, workerCount);
    }
}
