package cn.boboweike.carrot.server.configuration;

import cn.boboweike.carrot.server.TaskZooKeeper;
import cn.boboweike.carrot.server.concurrent.ConcurrentTaskModificationResolver;
import cn.boboweike.carrot.server.concurrent.DefaultConcurrentTaskModificationResolver;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;

/**
 * Default implementation of {@link ConcurrentTaskModificationPolicy}.
 * <p>
 * If Tasks are deleted, the {@link DefaultConcurrentTaskModificationPolicy} will resolve the concurrent task modification
 * by stopping the processing of the task. For other concurrent modifications, the {@link DefaultConcurrentTaskModificationPolicy} will
 * throw {@link cn.boboweike.carrot.server.concurrent.UnresolvableConcurrentTaskModificationException}
 * as these may point to programming errors (Carrot was conceived with the idea that once a
 * task is being processed, it should not be modified anymore).
 */
public class DefaultConcurrentTaskModificationPolicy implements ConcurrentTaskModificationPolicy {

    @Override
    public ConcurrentTaskModificationResolver toConcurrentTaskModificationResolver(PartitionedStorageProvider storageProvider, TaskZooKeeper taskZooKeeper) {
        return new DefaultConcurrentTaskModificationResolver(storageProvider, taskZooKeeper);
    }

}

