package cn.boboweike.carrot.server.configuration;

import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.server.strategy.BasicWorkDistributionStrategy;
import cn.boboweike.carrot.server.strategy.WorkDistributionStrategy;

public class FixedSizeBackgroundTaskServerWorkerPolicy implements BackgroundTaskServerWorkerPolicy {
    private final int workerCount;

    public FixedSizeBackgroundTaskServerWorkerPolicy(int workerCount) {
        this.workerCount = workerCount;
    }

    @Override
    public WorkDistributionStrategy toWorkDistributionStrategy(BackgroundTaskServer backgroundTaskServer) {
        return new BasicWorkDistributionStrategy(backgroundTaskServer, workerCount);
    }
}
