package cn.boboweike.carrot.server.dashboard;

import cn.boboweike.carrot.storage.CarrotMetadata;

public class NewCarrotVersionNotification implements DashboardNotification {
    private String latestVersion;

    public NewCarrotVersionNotification(CarrotMetadata metadata) {
        if (!metadata.getName().equals(NewCarrotVersionNotification.class.getSimpleName())) {
            throw new IllegalStateException("Can only be constructed for CarrotMetadata with key " + NewCarrotVersionNotification.class.getSimpleName());
        }
        this.latestVersion = metadata.getValue();
    }

    public NewCarrotVersionNotification(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    public String getLatestVersion() {
        return latestVersion;
    }
}
