package cn.boboweike.carrot.server.dashboard.mappers;

import cn.boboweike.carrot.server.dashboard.CpuAllocationIrregularityNotification;
import cn.boboweike.carrot.server.dashboard.DashboardNotification;
import cn.boboweike.carrot.storage.CarrotMetadata;

import java.util.UUID;

public class CpuAllocationIrregularityNotificationMapper implements DashboardNotificationMapper<CpuAllocationIrregularityNotification> {
    private final String id;

    public CpuAllocationIrregularityNotificationMapper(UUID backgroundTaskServerId) {
        this.id = "BackgroundTaskServer " + backgroundTaskServerId;
    }

    @Override
    public boolean supports(DashboardNotification notification) {
        return notification instanceof CpuAllocationIrregularityNotification;
    }

    @Override
    public CarrotMetadata mapToMetadata(CpuAllocationIrregularityNotification notification) {
        return new CarrotMetadata(CpuAllocationIrregularityNotification.class.getSimpleName(), id, notification.getAmountOfSeconds());
    }
}
