package cn.boboweike.carrot.server.jmx;

import java.time.Duration;
import java.time.Instant;
import java.util.UUID;

public interface BackgroundTaskServerStatusMBean {
    Integer NO_PARTITION = -1;

    UUID getId();

    int getWorkerPoolSize();

    int getPollIntervalInSeconds();

    Instant getFirstHeartbeat();

    Instant getLastHeartbeat();

    Duration getDeleteSucceededTasksAfter();

    Duration getPermanentlyDeleteDeletedTasksAfter();

    boolean isRunning();

    Long getSystemTotalMemory();

    Long getSystemFreeMemory();

    Double getSystemCpuLoad();

    Long getProcessMaxMemory();

    Long getProcessFreeMemory();

    Long getProcessAllocatedMemory();

    Double getProcessCpuLoad();

    Integer getPartition();
}
