package cn.boboweike.carrot.server.jmx;

import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.TaskStats;
import cn.boboweike.carrot.storage.TaskStatsData;
import cn.boboweike.carrot.storage.listeners.TaskStatsChangeListener;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import java.lang.management.ManagementFactory;
import java.time.Instant;

public class CarrotJMXExtensions implements TaskStatsChangeListener, TaskStatsMBean {
    private TaskStats taskStats;

    public CarrotJMXExtensions(BackgroundTaskServer backgroundTaskServer, PartitionedStorageProvider storageProvider) {
        try {
            onChange(storageProvider.getTaskStatsData());
            storageProvider.addTaskStorageOnChangeListener(this);

            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            StandardMBean backgroundTaskServerMBean = new StandardMBean(backgroundTaskServer, BackgroundTaskServerMBean.class);
            StandardMBean backgroundTaskServerStatusMBean = new StandardMBean(backgroundTaskServer.getServerStatus(), BackgroundTaskServerStatusMBean.class);
            StandardMBean backgroundTaskServerStatsMBean = new StandardMBean(this, TaskStatsMBean.class);
            server.registerMBean(backgroundTaskServerMBean, new ObjectName("cn.boboweike.carrot.server:type=BackgroundTaskServerInfo,name=BackgroundTaskServer"));
            server.registerMBean(backgroundTaskServerStatusMBean, new ObjectName("cn.boboweike.carrot.server:type=BackgroundTaskServerInfo,name=BackgroundTaskServerStatus"));
            server.registerMBean(backgroundTaskServerStatsMBean, new ObjectName("cn.boboweike.carrot.server:type=BackgroundTaskServerInfo,name=BackgroundTaskServerStatistics"));
        } catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onChange(TaskStatsData taskStatsData) {
        this.taskStats = taskStatsData.getOverallTaskStats();
    }

    @Override
    public Instant getTimeStamp() {
        return taskStats.getTimeStamp();
    }

    @Override
    public Long getTotal() {
        return taskStats.getTotal();
    }

    @Override
    public Long getScheduled() {
        return taskStats.getScheduled();
    }

    @Override
    public Long getEnqueued() {
        return taskStats.getEnqueued();
    }

    @Override
    public Long getProcessing() {
        return taskStats.getProcessing();
    }

    @Override
    public Long getFailed() {
        return taskStats.getFailed();
    }

    @Override
    public Long getSucceeded() {
        return taskStats.getSucceeded();
    }

    @Override
    public int getRecurringTasks() {
        return taskStats.getRecurringTasks();
    }

    @Override
    public int getBackgroundTaskServers() {
        return taskStats.getBackgroundTaskServers();
    }
}
