package cn.boboweike.carrot.server.runner;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskDetails;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;

import static cn.boboweike.carrot.utils.TaskUtils.getTaskMethod;

public class BackgroundStaticTaskWithoutIocRunner extends AbstractBackgroundTaskRunner {

    @Override
    public boolean supports(Task task) {
        TaskDetails taskDetails = task.getTaskDetails();
        return !taskDetails.hasStaticFieldName() && Modifier.isStatic(getTaskMethod(taskDetails).getModifiers());
    }

    @Override
    protected BackgroundTaskWorker getBackgroundTaskWorker(Task task) {
        return new StaticBackgroundTaskWorker(task);
    }

    protected static class StaticBackgroundTaskWorker extends BackgroundTaskWorker {

        public StaticBackgroundTaskWorker(Task task) {
            super(task);
        }

        @Override
        protected Object getTaskToPerform(Class<?> taskToPerformClass) {
            return null;
        }
    }
}
