package cn.boboweike.carrot.server.runner;

import cn.boboweike.carrot.server.TaskActivator;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskDetails;

import static cn.boboweike.carrot.utils.reflection.ReflectionUtils.toClass;

public class BackgroundTaskWithIocRunner extends AbstractBackgroundTaskRunner {
    private final TaskActivator taskActivator;

    public BackgroundTaskWithIocRunner(TaskActivator taskActivator) {
        this.taskActivator = taskActivator;
    }

    @Override
    public boolean supports(Task task) {
        if (taskActivator == null) return false;
        TaskDetails taskDetails = task.getTaskDetails();
        return !taskDetails.hasStaticFieldName() && taskActivator.activateTask(toClass(taskDetails.getClassName())) != null;
    }

    @Override
    protected BackgroundTaskWorker getBackgroundTaskWorker(Task task) {
        return new BackgroundForIoCTaskLambdaWorker(taskActivator, task);
    }

    protected static class BackgroundForIoCTaskLambdaWorker extends BackgroundTaskWorker {

        private final TaskActivator taskActivator;

        public BackgroundForIoCTaskLambdaWorker(TaskActivator taskActivator, Task task) {
            super(task);
            this.taskActivator = taskActivator;
        }

        @Override
        protected Object getTaskToPerform(Class<?> taskToPerformClass) {
            return taskActivator.activateTask(taskToPerformClass);
        }
    }
}
