package cn.boboweike.carrot.server.runner;

import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskDetails;

import static cn.boboweike.carrot.utils.reflection.ReflectionUtils.hasDefaultNoArgConstructor;

public class BackgroundTaskWithoutIocRunner extends AbstractBackgroundTaskRunner {
    @Override
    public boolean supports(Task task) {
        TaskDetails taskDetails = task.getTaskDetails();
        return !taskDetails.hasStaticFieldName() && hasDefaultNoArgConstructor(taskDetails.getClassName());
    }

    @Override
    protected BackgroundTaskWorker getBackgroundTaskWorker(Task task) {
        return new BackgroundForTaskLambdaWorker(task);
    }

    protected static class BackgroundForTaskLambdaWorker extends BackgroundTaskWorker {

        public BackgroundForTaskLambdaWorker(Task task) {
            super(task);
        }

    }
}
