package cn.boboweike.carrot.server.runner;

import cn.boboweike.carrot.tasks.context.TaskContext;

public class ThreadLocalTaskContext {

    private ThreadLocalTaskContext() {
    }

    private static final ThreadLocal<TaskContext> taskContextThreadLocal = new ThreadLocal<>();

    static void setTaskContext(TaskContext taskContext) {
        taskContextThreadLocal.set(taskContext);
    }

    static void clear() {
        taskContextThreadLocal.remove();
    }

    public static TaskContext getTaskContext() {
        return taskContextThreadLocal.get();
    }
}