package cn.boboweike.carrot.server.strategy;

import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.storage.PageRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static cn.boboweike.carrot.storage.PageRequest.ascOnUpdatedAt;

public class BasicWorkDistributionStrategy implements WorkDistributionStrategy {

    private static final Logger LOGGER = LoggerFactory.getLogger(BasicWorkDistributionStrategy.class);

    private final BackgroundTaskServer backgroundTaskServer;
    private final int workerCount;

    public BasicWorkDistributionStrategy(BackgroundTaskServer backgroundTaskServer, int workerCount) {
        this.backgroundTaskServer = backgroundTaskServer;
        this.workerCount = workerCount;
    }

    @Override
    public int getWorkerCount() {
        return workerCount;
    }

    @Override
    public boolean canOnboardNewWork() {
        final double occupiedWorkerCount = getOccupiedWorkerCount();
        final boolean canOnboardWork = (occupiedWorkerCount / workerCount) < 0.7;
        return canOnboardWork;
    }

    @Override
    public PageRequest getWorkPageRequest() {
        final int occupiedWorkerCount = getOccupiedWorkerCount();

        final int limit = workerCount - occupiedWorkerCount;
        LOGGER.debug("Can onboard {} new work (occupiedWorkerCount = {}; workerCount = {}).", limit, occupiedWorkerCount, workerCount);
        return ascOnUpdatedAt(limit);
    }

    private int getOccupiedWorkerCount() {
        return backgroundTaskServer.getTaskZooKeeper().getOccupiedWorkerCount();
    }
}
