package cn.boboweike.carrot.server.tasks;

import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.storage.CarrotMetadata;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;

import java.util.UUID;

public class CreateClusterIdIfNotExists implements Runnable {
    private final PartitionedStorageProvider storageProvider;

    public CreateClusterIdIfNotExists(BackgroundTaskServer backgroundTaskServer) {
        storageProvider = backgroundTaskServer.getStorageProvider();
    }

    @Override
    public void run() {
        CarrotMetadata metadata = storageProvider.getMetadata("id", "cluster");
        if (metadata == null) {
            storageProvider.saveMetadata(new CarrotMetadata("id", "cluster", UUID.randomUUID().toString()));
        }
    }
}
