package cn.boboweike.carrot.storage;

import cn.boboweike.carrot.server.jmx.BackgroundTaskServerStatusMBean;

import java.time.Duration;
import java.time.Instant;
import java.util.UUID;

public class BackgroundTaskServerStatus implements BackgroundTaskServerStatusMBean {
    private final UUID id;
    private final int workerPoolSize;
    private final int pollIntervalInSeconds;
    private final Duration deleteSucceededTasksAfter;
    private final Duration permanentlyDeleteDeletedTasksAfter;
    private final Instant firstHeartbeat;
    private final Instant lastHeartbeat;
    private final Integer partition;
    private final Boolean running;
    private final Long systemTotalMemory;
    private final Long systemFreeMemory;
    private final Double systemCpuLoad;
    private final Long processMaxMemory;
    private final Long processFreeMemory;
    private final Long processAllocatedMemory;
    private final Double processCpuLoad;

    public BackgroundTaskServerStatus(int workerPoolSize, int pollIntervalInSeconds, Duration deleteSucceededTasksAfter, Duration permanentlyDeleteDeletedTasksAfter) {
        this(UUID.randomUUID(), workerPoolSize, pollIntervalInSeconds, deleteSucceededTasksAfter, permanentlyDeleteDeletedTasksAfter, null, null, false, null, null, null, null, null, null, null, NO_PARTITION);
    }

    public BackgroundTaskServerStatus(UUID id, int workerPoolSize, int pollIntervalInSeconds, Duration deleteSucceededTasksAfter, Duration permanentlyDeleteDeletedTasksAfter, Instant firstHeartbeat, Instant lastHeartbeat, boolean isRunning, Long systemTotalMemory, Long systemFreeMemory, Double systemCpuLoad, Long processMaxMemory, Long processFreeMemory, Long processAllocatedMemory, Double processCpuLoad, Integer partition) {
        this.id = id;
        this.workerPoolSize = workerPoolSize;
        this.pollIntervalInSeconds = pollIntervalInSeconds;
        this.deleteSucceededTasksAfter = deleteSucceededTasksAfter;
        this.permanentlyDeleteDeletedTasksAfter = permanentlyDeleteDeletedTasksAfter;
        this.firstHeartbeat = firstHeartbeat;
        this.lastHeartbeat = lastHeartbeat;
        this.running = isRunning;
        this.systemTotalMemory = systemTotalMemory;
        this.systemFreeMemory = systemFreeMemory;
        this.systemCpuLoad = systemCpuLoad;
        this.processMaxMemory = processMaxMemory;
        this.processFreeMemory = processFreeMemory;
        this.processAllocatedMemory = processAllocatedMemory;
        this.processCpuLoad = processCpuLoad;
        this.partition = partition;
    }

    @Override
    public UUID getId() {
        return id;
    }

    @Override
    public int getWorkerPoolSize() {
        return workerPoolSize;
    }

    @Override
    public int getPollIntervalInSeconds() {
        return pollIntervalInSeconds;
    }

    @Override
    public Duration getDeleteSucceededTasksAfter() {
        return deleteSucceededTasksAfter;
    }

    @Override
    public Duration getPermanentlyDeleteDeletedTasksAfter() {
        return permanentlyDeleteDeletedTasksAfter;
    }

    @Override
    public Instant getFirstHeartbeat() {
        return firstHeartbeat;
    }

    @Override
    public Instant getLastHeartbeat() {
        return lastHeartbeat;
    }

    @Override
    public boolean isRunning() {
        return running;
    }

    @Override
    public Long getSystemTotalMemory() {
        return systemTotalMemory;
    }

    @Override
    public Long getSystemFreeMemory() {
        return systemFreeMemory;
    }

    @Override
    public Double getSystemCpuLoad() {
        return systemCpuLoad;
    }

    @Override
    public Long getProcessMaxMemory() {
        return processMaxMemory;
    }

    @Override
    public Long getProcessFreeMemory() {
        return processFreeMemory;
    }

    @Override
    public Long getProcessAllocatedMemory() {
        return processAllocatedMemory;
    }

    @Override
    public Double getProcessCpuLoad() {
        return processCpuLoad;
    }

    @Override
    public Integer getPartition() {
        return partition;
    }
}
