package cn.boboweike.carrot.storage;

import cn.boboweike.carrot.tasks.Task;

import java.util.List;
import java.util.stream.Collectors;

import static java.util.Collections.singletonList;

public class ConcurrentTaskModificationException extends StorageException {

    private final List<Task> concurrentUpdatedTasks;

    public ConcurrentTaskModificationException(Task concurrentUpdatedTask) {
        this(singletonList(concurrentUpdatedTask));
    }

    public ConcurrentTaskModificationException(List<Task> concurrentUpdatedTasks) {
        super("The following tasks where concurrently updated: " + concurrentUpdatedTasks.stream().map(task -> task.getId().toString()).collect(Collectors.joining(", ")));
        this.concurrentUpdatedTasks = concurrentUpdatedTasks;
    }

    public List<Task> getConcurrentUpdatedTasks() {
        return concurrentUpdatedTasks;
    }
}