package cn.boboweike.carrot.storage;

import java.time.Instant;

public class TaskStatsExtended extends TaskStats {
    private final Long amountSucceeded;
    private final Long amountFailed;
    private final Estimation estimation;

    public TaskStatsExtended(TaskStats taskStats) {
        super(taskStats);
        this.amountSucceeded = 0L;
        this.amountFailed = 0L;
        this.estimation = new Estimation(taskStats.getEnqueued() < 1 && taskStats.getProcessing() < 1);
    }

    public TaskStatsExtended(TaskStats taskStats, Long amountSucceeded, Long amountFailed, Instant estimatedProcessingFinishedInstant) {
        super(taskStats);
        this.amountSucceeded = amountSucceeded;
        this.amountFailed = amountFailed;
        this.estimation = new Estimation(taskStats.getEnqueued() < 1 && taskStats.getProcessing() < 1, estimatedProcessingFinishedInstant);
    }

    public Long getAmountSucceeded() {
        return amountSucceeded;
    }

    public Long getAmountFailed() {
        return amountFailed;
    }

    public Estimation getEstimation() {
        return estimation;
    }

    public static class Estimation {
        private final boolean processingDone;
        private final boolean estimatedProcessingTimeAvailable;
        private final Instant estimatedProcessingFinishedAt;

        public Estimation(boolean processingDone) {
            this.processingDone = processingDone;
            this.estimatedProcessingTimeAvailable = false;
            this.estimatedProcessingFinishedAt = null;
        }

        public Estimation(boolean processingDone, Instant estimatedProcessingFinishedAt) {
            this.processingDone = processingDone;
            this.estimatedProcessingTimeAvailable = estimatedProcessingFinishedAt != null;
            this.estimatedProcessingFinishedAt = estimatedProcessingFinishedAt;
        }

        public Instant getEstimatedProcessingFinishedAt() {
            return estimatedProcessingFinishedAt;
        }

        public boolean isProcessingDone() {
            return processingDone;
        }

        public boolean isEstimatedProcessingFinishedInstantAvailable() {
            return estimatedProcessingTimeAvailable;
        }
    }
}
