package cn.boboweike.carrot.storage.nosql.mongo.mapper;

import cn.boboweike.carrot.storage.CarrotMetadata;
import cn.boboweike.carrot.storage.StorageProviderUtils.*;
import org.bson.Document;

import java.util.Date;

public class MetadataDocumentMapper {
    public Document toInsertDocument(CarrotMetadata metadata) {
        final Document document = new Document();
        document.put("_id", metadata.getId());
        document.put(Metadata.FIELD_NAME, metadata.getName());
        document.put(Metadata.FIELD_OWNER, metadata.getOwner());
        document.put(Metadata.FIELD_VALUE, metadata.getValue());
        return document;
    }

    public Document toUpdateDocument(CarrotMetadata metadata) {
        final Document document = new Document();
        document.put("_id", metadata.getId());
        document.put(Metadata.FIELD_NAME, metadata.getName());
        document.put(Metadata.FIELD_OWNER, metadata.getOwner());
        document.put(Metadata.FIELD_VALUE, metadata.getValue());
        document.put(Metadata.FIELD_CREATED_AT, metadata.getCreatedAt());
        document.put(Metadata.FIELD_UPDATED_AT, metadata.getUpdatedAt());

        return new Document("$set", document);
    }

    public CarrotMetadata toCarrotMetadata(Document document) {

        return new CarrotMetadata(
                document.getString(Metadata.FIELD_NAME),
                document.getString(Metadata.FIELD_OWNER),
                document.getString(Metadata.FIELD_VALUE),
                document.get(Metadata.FIELD_CREATED_AT, Date.class).toInstant(),
                document.get(Metadata.FIELD_UPDATED_AT, Date.class).toInstant()
        );
    }
}
