package cn.boboweike.carrot.storage.nosql.mongo.migrations;

import cn.boboweike.carrot.storage.StorageProviderUtils.Tasks;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Indexes;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static cn.boboweike.carrot.storage.StorageProviderUtils.elementPrefixerWithPartition;
import static com.mongodb.client.model.Indexes.compoundIndex;

public class M001_CreateTaskCollection extends MongoMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(M001_CreateTaskCollection.class);
    @Override
    public void runMigration(MongoDatabase carrotDatabase, String collectionPrefix, Integer partition) {
        String collectionName = elementPrefixerWithPartition(collectionPrefix, Tasks.NAME, partition);
        if (collectionExists(carrotDatabase, collectionName)) {
            LOGGER.info("Skipping migration {} as it is already done", collectionName);
            return;
        }

        LOGGER.info("Running migration {}", collectionName);
        if (createCollection(carrotDatabase, collectionName)) {
            MongoCollection<Document> taskCollection = carrotDatabase.getCollection(collectionName, Document.class);
            taskCollection.createIndex(compoundIndex(Indexes.ascending(Tasks.FIELD_STATE), Indexes.ascending(Tasks.FIELD_SCHEDULED_AT)));
            taskCollection.createIndex(compoundIndex(Indexes.ascending(Tasks.FIELD_STATE), Indexes.ascending(Tasks.FIELD_UPDATED_AT)));
            taskCollection.createIndex(compoundIndex(Indexes.ascending(Tasks.FIELD_STATE), Indexes.descending(Tasks.FIELD_UPDATED_AT)));
            taskCollection.createIndex(compoundIndex(Indexes.ascending(Tasks.FIELD_STATE), Indexes.ascending(Tasks.FIELD_CREATED_AT)));
            taskCollection.createIndex(compoundIndex(Indexes.ascending(Tasks.FIELD_STATE), Indexes.ascending(Tasks.FIELD_TASK_SIGNATURE)));
        }
    }

    @Override
    public boolean supportPartition() {
        return true;
    }
}
