package cn.boboweike.carrot.storage.nosql.mongo.migrations;

import cn.boboweike.carrot.storage.StorageProviderUtils.RecurringTasks;
import com.mongodb.client.MongoDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static cn.boboweike.carrot.storage.StorageProviderUtils.elementPrefixerWithPartition;

public class M002_CreateRecurringTaskCollection extends MongoMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(M002_CreateRecurringTaskCollection.class);
    @Override
    public void runMigration(MongoDatabase carrotDatabase, String collectionPrefix, Integer partition) {
        String collectionName = elementPrefixerWithPartition(collectionPrefix, RecurringTasks.NAME, partition);
        if (collectionExists(carrotDatabase, collectionName)) {
            LOGGER.info("Skipping migration {} as it is already done", collectionName);
            return;
        }

        LOGGER.info("Running migration {}", collectionName);
        createCollection(carrotDatabase, collectionName);
    }

    @Override
    public boolean supportPartition() {
        return true;
    }
}
