package cn.boboweike.carrot.storage.nosql.mongo.migrations;

import cn.boboweike.carrot.storage.StorageProviderUtils.Metadata;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Indexes;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static cn.boboweike.carrot.storage.StorageProviderUtils.elementPrefixer;
import static com.mongodb.client.model.Indexes.compoundIndex;

public class M003_CreateMetadataCollection extends MongoMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(M003_CreateMetadataCollection.class);
    @Override
    public void runMigration(MongoDatabase carrotDatabase, String collectionPrefix, Integer partition) {
        String collectionName = elementPrefixer(collectionPrefix, Metadata.NAME);

        if (collectionExists(carrotDatabase, collectionName)) {
            LOGGER.info("Skipping migration {} as it is already done", collectionName);
            return;
        }

        LOGGER.info("Running migration {}", collectionName);
        if (createCollection(carrotDatabase, collectionName)) {
            createMetadataCollection(carrotDatabase, collectionName);
        }
    }

    private void createMetadataCollection(MongoDatabase carrotDatabase, String processedMetadataCollectionName) {
        MongoCollection<Document> metadataCollection = carrotDatabase.getCollection(processedMetadataCollectionName, Document.class);
        metadataCollection.createIndex(compoundIndex(Indexes.ascending(Metadata.FIELD_NAME), Indexes.ascending(Metadata.FIELD_OWNER)));
        metadataCollection.insertOne(initialAllTimeSucceededTaskCounterDocument());
    }

    private Document initialAllTimeSucceededTaskCounterDocument() {
        final Document document = new Document();
        document.put(Metadata.FIELD_ID, Metadata.STATS_ID);
        document.put(Metadata.FIELD_NAME, "succeeded-tasks-counter");
        document.put(Metadata.FIELD_OWNER, "cluster");
        document.put(Metadata.FIELD_VALUE, 0L);
        return document;
    }
}
