package cn.boboweike.carrot.storage.nosql.mongo.migrations;

import cn.boboweike.carrot.storage.StorageProviderUtils;
import com.mongodb.client.MongoDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static cn.boboweike.carrot.storage.StorageProviderUtils.elementPrefixer;

public class M004_CreateBackgroundTaskServerCollection extends MongoMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(M004_CreateBackgroundTaskServerCollection.class);
    @Override
    public void runMigration(MongoDatabase carrotDatabase, String collectionPrefix, Integer partition) {
        // partition is not used for BackgroundTaskServerCollection
        String collectionName = elementPrefixer(collectionPrefix, StorageProviderUtils.BackgroundTaskServers.NAME);

        if (collectionExists(carrotDatabase, collectionName)) {
            LOGGER.info("Skipping migration {} as it is already done", collectionName);
            return;
        }

        LOGGER.info("Running migration {}", collectionName);
        createCollection(carrotDatabase, collectionName);
    }
}
