package cn.boboweike.carrot.storage.nosql.mongo.migrations;

import cn.boboweike.carrot.storage.StorageProviderUtils;
import com.mongodb.client.MongoDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static cn.boboweike.carrot.storage.StorageProviderUtils.elementPrefixer;
import static cn.boboweike.carrot.storage.StorageProviderUtils.*;

public class M005_CreateShedLockCollection extends MongoMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(M005_CreateShedLockCollection.class);

    @Override
    public void runMigration(MongoDatabase carrotDatabase, String collectionPrefix, Integer partition) {
        // partition is not used for ShedLockCollection
        String collectionName = elementPrefixer(collectionPrefix, ShedLock.NAME);

        if (collectionExists(carrotDatabase, collectionName)) {
            LOGGER.info("Skipping migration {} as it is already done", collectionName);
            return;
        }

        LOGGER.info("Running migration {}", collectionName);
        createCollection(carrotDatabase, collectionName);
    }
}
