package cn.boboweike.carrot.storage.nosql.mongo.migrations;

import cn.boboweike.carrot.storage.nosql.common.migrations.NoSqlMigration;
import com.mongodb.MongoCommandException;
import com.mongodb.client.MongoDatabase;

import java.util.LinkedList;

public abstract class MongoMigration implements NoSqlMigration {
    public abstract void runMigration(MongoDatabase mongoDatabase, String collectionPrefix, Integer partition);

    protected boolean createCollection(MongoDatabase carrotDatabase, String name) {
        try {
            carrotDatabase.createCollection(name);
            return true;
        } catch (MongoCommandException mongoCommandException) {
            if (mongoCommandException.getErrorCode() == 48) {
                return false;
            }
            throw mongoCommandException;
        }
    }

    protected boolean collectionExists(MongoDatabase mongoDatabase, String collectionName) {
        return mongoDatabase.listCollectionNames().into(new LinkedList<>()).contains(collectionName);
    }

    public boolean supportPartition() {
        return false;
    }

    @Override
    public String getClassName() {
        return this.getClass().getSimpleName() + ".class";
    }
}
