package cn.boboweike.carrot.tasks;

import cn.boboweike.carrot.utils.TaskUtils;
import cn.boboweike.carrot.utils.resilience.Lock;
import cn.boboweike.carrot.utils.resilience.Lockable;

public abstract class AbstractTask implements Lockable {

    private final transient Lock locker;

    private volatile int version;
    private String taskSignature;
    private String taskName;
    private TaskDetails taskDetails;

    protected AbstractTask() {
        // used for deserialization
        this.locker = new Lock();
    }

    protected AbstractTask(TaskDetails taskDetails) {
        this(taskDetails, 0);
    }

    protected AbstractTask(TaskDetails taskDetails, int version) {
        this();
        this.taskDetails = taskDetails;
        this.version = version;
        this.taskSignature = TaskUtils.getTaskSignature(taskDetails);
    }

    public abstract Object getId();

    public int getVersion() {
        return version;
    }

    /**
     * Increases the version of this Task instance
     *
     * @return the version after it was increased
     */
    synchronized int increaseVersion() {
        return ++version;
    }

    void setVersion(int version) {
        this.version = version;
    }

    public String getTaskSignature() {
        return taskSignature;
    }

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public TaskDetails getTaskDetails() {
        return taskDetails;
    }

    @Override
    public Lock lock() {
        return locker.lock();
    }
}
