package cn.boboweike.carrot.tasks;

import cn.boboweike.carrot.tasks.lambdas.TaskRequest;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;

import java.util.ArrayList;
import java.util.List;

import static cn.boboweike.carrot.utils.CollectionUtils.asArrayList;
import static java.util.Arrays.asList;
import static java.util.Collections.unmodifiableList;

public class TaskDetails {

    private final String className;
    private final String staticFieldName;
    private final String methodName;
    private final ArrayList<TaskParameter> taskParameters;
    private Boolean cacheable;

    private TaskDetails() {
        this(null, null, null, null);
        // used for deserialization
    }

    public TaskDetails(TaskRequest taskRequest) {
        this(taskRequest.getTaskRequestHandler().getName(), null, "run", asList(new TaskParameter(taskRequest)));
        this.cacheable = true;
    }

    public TaskDetails(String className, String staticFieldName, String methodName, List<TaskParameter> taskParameters) {
        this.className = className;
        this.staticFieldName = staticFieldName;
        this.methodName = methodName;
        this.taskParameters = asArrayList(taskParameters);
        this.cacheable = false;
    }

    public String getClassName() {
        return className;
    }

    public String getStaticFieldName() {
        return staticFieldName;
    }

    public boolean hasStaticFieldName() {
        return staticFieldName != null;
    }

    public String getMethodName() {
        return methodName;
    }

    public List<TaskParameter> getTaskParameters() {
        return unmodifiableList(taskParameters);
    }

    public Class[] getTaskParameterTypes() {
        return taskParameters.stream()
                .map(TaskParameter::getClassName)
                .map(ReflectionUtils::toClass)
                .toArray(Class[]::new);
    }

    public Object[] getTaskParameterValues() {
        return taskParameters.stream()
                .map(TaskParameter::getObject)
                .toArray();
    }

    public Boolean getCacheable() {
        return cacheable;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }
}
