package cn.boboweike.carrot.tasks;

import java.util.UUID;

/**
 * Class which represents the Id of the task.
 */
public class TaskId {

    private final UUID uuid;

    public TaskId(UUID uuid) {
        this.uuid = uuid;
    }

    public UUID asUUID() {
        return uuid;
    }

    @Override
    public int hashCode() {
        return uuid.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof TaskId) {
            return uuid.equals(((TaskId) obj).uuid);
        }
        return false;
    }

    @Override
    public String toString() {
        return uuid.toString();
    }

    public static TaskId parse(String uuidAsString) {
        return new TaskId(UUID.fromString(uuidAsString));
    }
}
