package cn.boboweike.carrot.tasks;

import java.util.List;
import java.util.Set;
import java.util.UUID;

import static java.util.stream.Collectors.toList;
import static java.util.stream.Collectors.toSet;

public class TaskListVersioner implements AutoCloseable {

    private final List<TaskVersioner> taskVersioners;

    public TaskListVersioner(List<Task> tasks) {
        this.taskVersioners = tasks.stream().map(TaskVersioner::new).collect(toList());
    }

    public boolean areNewTasks() {
        validateTasks();
        return taskVersioners.get(0).isNewTask();
    }

    public void validateTasks() {
        if(taskVersioners.get(0).isNewTask()) {
            if(! taskVersioners.stream().allMatch(TaskVersioner::isNewTask)) {
                throw new IllegalArgumentException("All tasks must be either new (with id == null) or existing (with id != null)");
            }
        } else {
            if(taskVersioners.stream().anyMatch(TaskVersioner::isNewTask)) {
                throw new IllegalArgumentException("All tasks must be either new (with id == null) or existing (with id != null)");
            }
        }
    }

    public void commitVersions() {
        this.taskVersioners.forEach(TaskVersioner::commitVersion);
    }

    public void rollbackVersions(List<Task> tasksThatFailed) {
        Set<UUID> taskIdsThatFailed = tasksThatFailed.stream().map(Task::getId).collect(toSet());
        this.taskVersioners.stream()
                .filter(taskVersioner -> !taskIdsThatFailed.contains(taskVersioner.getTask().getId()))
                .forEach(TaskVersioner::commitVersion);
    }

    @Override
    public void close() {
        this.taskVersioners.forEach(TaskVersioner::close);
    }
}
