package cn.boboweike.carrot.tasks;

import cn.boboweike.carrot.tasks.context.TaskContext;

public class TaskParameter {
    public static final TaskParameter TaskContext = new TaskParameter(TaskContext.class);

    private String className;
    private String actualClassName;
    private Object object;

    private TaskParameter() {
        // used for deserialization
    }

    private TaskParameter(Class<?> clazz) {
        this(clazz.getName(), null);
    }

    public TaskParameter(Class<?> clazz, Object object) {
        this(clazz.getName(), object);
    }

    public TaskParameter(Object object) {
        this(object.getClass().getName(), object);
    }

    public TaskParameter(String className, Object object) {
        this.className = className;
        this.actualClassName = isNotNullNorAnEnum(object) ? object.getClass().getName() : className;
        this.object = object;
    }

    /**
     * Represents the class name expected by the task method (e.g. an object or an interface)
     *
     * @return the class name expected by the task method (e.g. an object or an interface)
     */
    public String getClassName() {
        return className;
    }

    /**
     * Represents the actual class name of the task parameter (e.g. an object), this will never be an interface
     *
     * @return the actual class name of the task parameter (e.g. an object), this will never be an interface
     */
    public String getActualClassName() {
        return actualClassName;
    }

    /**
     * The actual task parameter
     *
     * @return the actual task parameter
     */
    public Object getObject() {
        return object;
    }



    private static boolean isNotNullNorAnEnum(Object object) {
        return object != null && !(object instanceof Enum);
    }
}
