package cn.boboweike.carrot.tasks;

public class TaskVersioner implements AutoCloseable {

    private final Task task;
    private final int initialTaskVersion;
    private boolean isVersionCommitted = false;


    public TaskVersioner(Task task) {
        this.task = task;
        this.initialTaskVersion = task.getVersion();
        this.task.increaseVersion();
    }

    public boolean isNewTask() {
        return this.initialTaskVersion == 0;
    }

    public void commitVersion() {
        isVersionCommitted = true;
    }

    Task getTask() {
        return task;
    }

    @Override
    public void close() {
        if(!isVersionCommitted) {
            task.setVersion(initialTaskVersion);
        }
    }
}