package cn.boboweike.carrot.tasks.annotations;

import cn.boboweike.carrot.tasks.filters.TaskFilter;

import java.lang.annotation.*;

/**
 * Allows to add a specific name to a task that will be used in the dashboard as well as extra taskFilters that will be used for the task.
 * The annotation can be used on the method that is referenced in the lambda.
 *
 * <h3>An example:</h3>
 * <pre>
 *      public class MyService {
 *
 *          {@literal @}Task(name = "Doing some work", taskFilters = {TheSunIsAlwaysShiningElectStateFilter.class, TestFilter.class})
 *          public void doWork() {
 *              // some long running task
 *          }
 *      }
 *
 *      MyService service = new MyService();
 *      BackgroundTask.enqueue(() -&gt; service.doWork());
 * </pre>
 * <p>
 * In the Task name you can also reference parameters which where passed to the method. This is done by means of the syntax <em>%{index}</em> where index is the zero-based index of your parameters.
 *
 * <h3>An example:</h3>
 * <pre>
 *       public class MyService {
 *
 *           {@literal @}Task(name = "Doing some work for user %0", taskFilters = {TheSunIsAlwaysShiningElectStateFilter.class, TestFilter.class})
 *           public void doWork(String userName) {
 *               // some long running task
 *           }
 *       }
 *
 *       MyService service = new MyService();
 *       BackgroundTask.enqueue(() -&gt; service.doWork("Ronald"));
 *  </pre>
 */

@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
public @interface Task {

    int NBR_OF_RETRIES_NOT_PROVIDED = -1;

    String name() default "";

    int retries() default NBR_OF_RETRIES_NOT_PROVIDED;

    Class<? extends TaskFilter>[] taskFilters() default {};
}
