package cn.boboweike.carrot.tasks.context;

import cn.boboweike.carrot.server.runner.RunnerTaskContext;
import cn.boboweike.carrot.tasks.Task;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

import cn.boboweike.carrot.tasks.context.TaskDashboardLogger.Level;

public class CarrotDashboardLogger implements Logger {

    private static final ThreadLocal<TaskDashboardLogger> taskDashboardLoggerThreadLocal = new ThreadLocal<>();
    private final Logger logger;
    private final Level threshold;

    public CarrotDashboardLogger(Logger logger) {
        this(logger, Level.INFO);
    }

    public CarrotDashboardLogger(Logger logger, Level threshold) {
        this.logger = logger;
        this.threshold = threshold;
    }

    public static void setTask(Task task) {
        taskDashboardLoggerThreadLocal.set(new RunnerTaskContext(task).logger());
    }

    public static void clearTask() {
        taskDashboardLoggerThreadLocal.remove();
    }

    @Override
    public String getName() {
        return logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return logger.isTraceEnabled();
    }

    @Override
    public void trace(String msg) {
        logger.trace(msg);
    }

    @Override
    public void trace(String format, Object arg) {
        logger.trace(format, arg);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        logger.trace(format, arg1, arg2);
    }

    @Override
    public void trace(String format, Object... arguments) {
        logger.trace(format, arguments);
    }

    @Override
    public void trace(String msg, Throwable t) {
        logger.trace(msg, t);
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return logger.isTraceEnabled(marker);
    }

    @Override
    public void trace(Marker marker, String msg) {
        logger.trace(marker, msg);
    }

    @Override
    public void trace(Marker marker, String format, Object arg) {
        logger.trace(marker, format, arg);
    }

    @Override
    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        logger.trace(marker, format, arg1, arg2);
    }

    @Override
    public void trace(Marker marker, String format, Object... argArray) {
        logger.trace(marker, format, argArray);
    }

    @Override
    public void trace(Marker marker, String msg, Throwable t) {
        logger.trace(marker, msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return logger.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        logger.debug(msg);
    }

    @Override
    public void debug(String format, Object arg) {
        logger.debug(format, arg);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        logger.debug(format, arg1, arg2);
    }

    @Override
    public void debug(String format, Object... arguments) {
        logger.debug(format, arguments);
    }

    @Override
    public void debug(String msg, Throwable t) {
        logger.debug(msg, t);
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return logger.isDebugEnabled(marker);
    }

    @Override
    public void debug(Marker marker, String msg) {
        logger.debug(marker, msg);
    }

    @Override
    public void debug(Marker marker, String format, Object arg) {
        logger.debug(marker, format, arg);
    }

    @Override
    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        logger.debug(marker, format, arg1, arg2);
    }

    @Override
    public void debug(Marker marker, String format, Object... arguments) {
        logger.debug(marker, format, arguments);
    }

    @Override
    public void debug(Marker marker, String msg, Throwable t) {
        logger.debug(marker, msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return logger.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        logger.info(msg);
        logInfoToTaskDashboard(msg);
    }

    @Override
    public void info(String format, Object arg) {
        logger.info(format, arg);
        logInfoToTaskDashboard(format, arg);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        logger.info(format, arg1, arg2);
        logInfoToTaskDashboard(format, arg1, arg2);
    }

    @Override
    public void info(String format, Object... arguments) {
        logger.info(format, arguments);
        logInfoToTaskDashboard(format, arguments);
    }

    @Override
    public void info(String msg, Throwable t) {
        logger.info(msg, t);
        logInfoToTaskDashboard(msg);
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return logger.isInfoEnabled(marker);
    }

    @Override
    public void info(Marker marker, String msg) {
        logger.info(marker, msg);
        logInfoToTaskDashboard(msg);
    }

    @Override
    public void info(Marker marker, String format, Object arg) {
        logger.info(marker, format, arg);
        logInfoToTaskDashboard(format, arg);
    }

    @Override
    public void info(Marker marker, String format, Object arg1, Object arg2) {
        logger.info(marker, format, arg1, arg2);
        logInfoToTaskDashboard(format, arg1, arg2);
    }

    @Override
    public void info(Marker marker, String format, Object... arguments) {
        logger.info(marker, format, arguments);
        logInfoToTaskDashboard(format, arguments);
    }

    @Override
    public void info(Marker marker, String msg, Throwable t) {
        logger.info(marker, msg, t);
        logInfoToTaskDashboard(msg);
    }

    @Override
    public boolean isWarnEnabled() {
        return logger.isWarnEnabled();
    }

    @Override
    public void warn(String msg) {
        logger.warn(msg);
        logWarnToTaskDashboard(msg);
    }

    @Override
    public void warn(String format, Object arg) {
        logger.warn(format, arg);
        logWarnToTaskDashboard(format, arg);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        logger.warn(format, arg1, arg2);
        logWarnToTaskDashboard(format, arg1, arg2);
    }

    @Override
    public void warn(String format, Object... arguments) {
        logger.warn(format, arguments);
        logWarnToTaskDashboard(format, arguments);
    }

    @Override
    public void warn(String msg, Throwable t) {
        logger.warn(msg, t);
        logWarnToTaskDashboard(msg);
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return logger.isWarnEnabled(marker);
    }

    @Override
    public void warn(Marker marker, String msg) {
        logger.warn(marker, msg);
        logWarnToTaskDashboard(msg);
    }

    @Override
    public void warn(Marker marker, String format, Object arg) {
        logger.warn(marker, format, arg);
        logWarnToTaskDashboard(format, arg);
    }

    @Override
    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        logger.warn(marker, format, arg1, arg2);
        logWarnToTaskDashboard(format, arg1, arg2);
    }

    @Override
    public void warn(Marker marker, String format, Object... arguments) {
        logger.warn(marker, format, arguments);
        logWarnToTaskDashboard(format, arguments);
    }

    @Override
    public void warn(Marker marker, String msg, Throwable t) {
        logger.warn(marker, msg, t);
        logWarnToTaskDashboard(msg);
    }

    @Override
    public boolean isErrorEnabled() {
        return logger.isErrorEnabled();
    }

    @Override
    public void error(String msg) {
        logger.error(msg);
        logErrorToTaskDashboard(msg);
    }

    @Override
    public void error(String format, Object arg) {
        logger.error(format, arg);
        logErrorToTaskDashboard(format, arg);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        logger.error(format, arg1, arg2);
        logErrorToTaskDashboard(format, arg1, arg2);
    }

    @Override
    public void error(String format, Object... arguments) {
        logger.error(format, arguments);
        logErrorToTaskDashboard(format, arguments);
    }

    @Override
    public void error(String msg, Throwable t) {
        logger.error(msg, t);
        logErrorToTaskDashboard(msg);
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return logger.isErrorEnabled(marker);
    }

    @Override
    public void error(Marker marker, String msg) {
        logger.error(marker, msg);
        logErrorToTaskDashboard(msg);
    }

    @Override
    public void error(Marker marker, String format, Object arg) {
        logger.error(marker, format, arg);
        logErrorToTaskDashboard(format, arg);
    }

    @Override
    public void error(Marker marker, String format, Object arg1, Object arg2) {
        logger.error(marker, format, arg1, arg2);
        logErrorToTaskDashboard(format, arg1, arg2);
    }

    @Override
    public void error(Marker marker, String format, Object... arguments) {
        logger.error(marker, format, arguments);
        logErrorToTaskDashboard(format, arguments);
    }

    @Override
    public void error(Marker marker, String msg, Throwable t) {
        logger.error(marker, msg, t);
        logErrorToTaskDashboard(msg);
    }

    private void logInfoToTaskDashboard(String message) {
        if (threshold.compareTo(Level.INFO) > 0) return;
        if (taskDashboardLoggerThreadLocal.get() != null) {
            taskDashboardLoggerThreadLocal.get().info(message);
        }
    }

    private void logInfoToTaskDashboard(String format, Object... args) {
        if (threshold.compareTo(Level.INFO) > 0) return;
        if (taskDashboardLoggerThreadLocal.get() != null) {
            FormattingTuple tp = MessageFormatter.arrayFormat(format, args);
            taskDashboardLoggerThreadLocal.get().info(tp.getMessage());
        }
    }

    private void logWarnToTaskDashboard(String message) {
        if (threshold.compareTo(Level.WARN) > 0) return;
        if (taskDashboardLoggerThreadLocal.get() != null) {
            taskDashboardLoggerThreadLocal.get().warn(message);
        }
    }

    private void logWarnToTaskDashboard(String format, Object... args) {
        if (threshold.compareTo(Level.WARN) > 0) return;
        if (taskDashboardLoggerThreadLocal.get() != null) {
            FormattingTuple tp = MessageFormatter.arrayFormat(format, args);
            taskDashboardLoggerThreadLocal.get().warn(tp.getMessage());
        }
    }

    private void logErrorToTaskDashboard(String message) {
        if (taskDashboardLoggerThreadLocal.get() != null) {
            taskDashboardLoggerThreadLocal.get().error(message);
        }
    }

    private void logErrorToTaskDashboard(String format, Object... args) {
        if (taskDashboardLoggerThreadLocal.get() != null) {
            FormattingTuple tp = MessageFormatter.arrayFormat(format, args);
            taskDashboardLoggerThreadLocal.get().error(tp.getMessage());
        }
    }
}
