package cn.boboweike.carrot.tasks.details;

import cn.boboweike.carrot.tasks.lambdas.IocTaskLambda;

import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.List;

import static cn.boboweike.carrot.tasks.details.TaskDetailsGeneratorUtils.findParamTypesFromDescriptorAsArray;
import static cn.boboweike.carrot.tasks.details.TaskDetailsGeneratorUtils.toFQClassName;
import static java.util.Arrays.asList;

public class JavaTaskDetailsBuilder extends TaskDetailsBuilder {

    public JavaTaskDetailsBuilder(SerializedLambda serializedLambda, Object... params) {
        super(initLocalVariables(serializedLambda, params), toFQClassName(serializedLambda.getImplClass()), serializedLambda.getImplMethodName());
    }

    protected static List<Object> initLocalVariables(SerializedLambda serializedLambda, Object[] params) {
        List<Object> result = new ArrayList<>();
        final Class<?>[] paramTypesFromDescriptor = findParamTypesFromDescriptorAsArray(serializedLambda.getImplMethodSignature());
        final boolean isIoCTaskLambda = IocTaskLambda.class.getName().equals(toFQClassName(serializedLambda.getFunctionalInterfaceClass()));
        for (int i = 0; i < serializedLambda.getCapturedArgCount(); i++) {
            final Object capturedArg = serializedLambda.getCapturedArg(i);
            result.add(capturedArg);
            if (isPrimitiveLongOrDouble(isIoCTaskLambda, paramTypesFromDescriptor, i, capturedArg)) { //why: If the local variable at index is of type double or long, it occupies both index and index + 1. See https://docs.oracle.com/javase/specs/jvms/se8/html/jvms-4.html
                result.add(null);
            }
        }
        result.addAll(asList(params));
        if (isIoCTaskLambda) {
            result.add(null); // will be injected by IoC
        }
        return result;
    }

    private static boolean isPrimitiveLongOrDouble(boolean isIoCTaskLambda, Class<?>[] paramTypesFromDescriptor, int captureArgCounter, Object capturedArg) {
        if (isIoCTaskLambda) {
            return isPrimitiveLongOrDouble(paramTypesFromDescriptor[captureArgCounter], capturedArg);
        } else {
            return captureArgCounter > 0 && isPrimitiveLongOrDouble(paramTypesFromDescriptor[captureArgCounter - 1], capturedArg);
        }
    }

    private static boolean isPrimitiveLongOrDouble(Class<?> paramTypeFromDescriptor, Object capturedArg) {
        return paramTypeFromDescriptor.isPrimitive() && (capturedArg instanceof Long || capturedArg instanceof Double);
    }
}

