package cn.boboweike.carrot.tasks.details;

import cn.boboweike.carrot.tasks.lambdas.CarrotTask;

import java.io.InputStream;
import java.lang.invoke.SerializedLambda;

import static cn.boboweike.carrot.tasks.details.TaskDetailsGeneratorUtils.getJavaClassContainingLambdaAsInputStream;
import static cn.boboweike.carrot.utils.StringUtils.substringAfter;
import static java.util.Arrays.stream;

public class JavaTaskDetailsFinder extends AbstractTaskDetailsFinder {

    private final CarrotTask carrotTask;
    private final SerializedLambda serializedLambda;
    private final boolean isLambda;

    JavaTaskDetailsFinder(CarrotTask carrotTask, SerializedLambda serializedLambda, Object... params) {
        super(new JavaTaskDetailsBuilder(serializedLambda, params));
        this.carrotTask = carrotTask;
        this.serializedLambda = serializedLambda;
        this.isLambda = (serializedLambda.getImplMethodName().startsWith("lambda$") || serializedLambda.getImplMethodName().contains("$lambda-"));
        if(isLambda) {
            parse(getClassContainingLambdaAsInputStream());
        } else if(serializedLambda.getCapturedArgCount() == 1 &&
                stream(serializedLambda.getCapturedArg(0).getClass().getAnnotations())
                        .anyMatch(ann -> "kotlin.Metadata".equals(ann.annotationType().getName()))) {
            // kotlin method reference
            this.taskDetailsBuilder.setClassName(serializedLambda.getCapturedArg(0).getClass().getName());
            this.taskDetailsBuilder.setMethodName(serializedLambda.getImplMethodName().contains("$") ?
                    substringAfter(serializedLambda.getImplMethodName(), "$")
                    : serializedLambda.getImplMethodName());
        }
    }

    @Override
    protected boolean isLambdaContainingTaskDetails(String name) {
        return isLambda && name.equals(serializedLambda.getImplMethodName());
    }

    @Override
    protected InputStream getClassContainingLambdaAsInputStream() {
        return getJavaClassContainingLambdaAsInputStream(carrotTask);
    }

}